package ga.core.goperators;

import ga.core.individual.IIndividual;
import ga.core.individual.IndividualList;
import ga.core.validation.GAContext;

/**
 * Interface for a crossover operator.
 * 
 * @param <T>
 *          The generic type of individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface ICrossoverOp<T extends IIndividual<T>> extends IGeneticOp {

  /**
   * Performs a crossover (if probability met) of the given individuals and
   * returns a list of the results.
   * 
   * @param individual1
   *          First individual
   * @param individual2
   *          Second individual
   * @param context
   *          The GA context.
   * @return List of the results.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public IndividualList<T> crossover(T individual1, T individual2,
      GAContext context);
}
